#pragma once

#include "context.h"
#include "logger.h"

#include <macs_pg/logging.h>
#include <yplatform/log.h>

#include <boost/algorithm/string/replace.hpp>

namespace NMdb {

class TMacsLog: public macs::pg::logging::Log {
public:
    using TMethod = macs::pg::logging::Method;
    using TMessage = macs::pg::logging::Message;

    TMacsLog(TContextPtr ctx): ctx(ctx) {}

    void warning(const TMethod& method, const TMessage& message) {
        MDBSAVE_LOG_WARN(ctx, log::method=method, logdog::message=boost::replace_all_copy(message, "\n", "\\n"));
    }

    void error(const TMethod& method, const TMessage& message) {
        MDBSAVE_LOG_ERROR(ctx, log::method=method, logdog::message=boost::replace_all_copy(message, "\n", "\\n"));
    }

    void notice(const TMethod& method, const TMessage& message) {
        MDBSAVE_LOG_NOTICE(ctx, log::method=method, logdog::message=boost::replace_all_copy(message, "\n", "\\n"));
    }

    void debug(const TMethod& method, const TMessage& message) {
        MDBSAVE_LOG_DEBUG(ctx, log::method=method, logdog::message=boost::replace_all_copy(message, "\n", "\\n"));
    }

private:
    TContextPtr ctx;
};

using TMacsLogPtr = boost::shared_ptr<TMacsLog>;

} // namespace NMdb
