#pragma once

#include <macs_pg/service/factory.h>
#include <pa/async.h>
#include <pgg/profiling.h>
#include <yplatform/task_context.h>

namespace NMdb {

class TMacsProfiler: public macs::pg::profiling::Log {
public:
    TMacsProfiler(yplatform::task_context_ptr context): Context(context) {}

    void write(
        const std::string&,
        const std::string& info,
        pgg::Duration duration) const override
    {
        pa::async_profiler::add(pa::postgresql, "macs_pg", info, Context->uniq_id(),
            static_cast<uint32_t>(macs::pg::Milliseconds(duration).count()));
    }

private:
    yplatform::task_context_ptr Context;
};

} // namespace NMdb
