#pragma once

#include "context.h"
#include "types.h"

#include <macs_pg/service/service.h>
#include <macs_pg/macs_pg.h>

#include <yplatform/task_context.h>

#include <vector>

#include <util/generic/maybe.h>

namespace NMdb {

using TSpamReportLogger = std::shared_ptr<yplatform::log::tskv_logger>;

struct TResolvedLabel {
    TLid Lid;
    TLabelSymbol Symbol;
    std::string Name;
};

struct TResolvedFolder {
    std::string Fid;
    std::string Name;
    std::string Type;
    int TypeCode = 0;
};

struct TSpamReport {
    TResolvedFolder OriginalFolder;
    TResolvedFolder DestinationFolder;
    std::vector<TResolvedLabel> AddedLabels;
    bool Seen = false;
};

struct TStoreResult {
    macs::Envelope Envelope;
    bool Duplicate = false;
    TResolvedFolder Folder;
    std::vector<TResolvedLabel> Labels;
    TSpamReport SpamReport;
};

struct TStoreParams {
    bool IgnoreDuplicates = false;
    bool NeedRemoveDuplicates = false;
    bool DisablePush = false;
    bool StoreAsDeleted = false;
    bool Imap = false;
};

struct TLabelsArgs {
    std::vector<TLid> Lids;
    std::vector<TLabelSymbol> Symbols;
    std::vector<TLabel> Labels;
};

struct TMdbModule {
    using THandler = std::function<void(boost::system::error_code, const TStoreResult&)>;

    virtual ~TMdbModule() = default;

    virtual void Save(
        TContextPtr context,
        const std::string& sessionId,
        const TUserInfo& userInfo,
        const TMessageBase& message,
        const TFolderCoords& destFolder,
        const TLabelsArgs& labels,
        const TMaybeFail<TTab>& tab,
        const THeaders& headers,
        const std::vector<TAttachment>& attachments,
        const std::vector<TMimePart>& parts,
        const TThreadInfo& threadInfo,
        const TStoreParams& params,
        ENoSuchFolderAction noSuchFolderAction,
        const TMaybeFail<TFilterActions>& filterActions,
        const THandler& handler) = 0;

    virtual void Update(
        TContextPtr context,
        const std::string& sessionId,
        const TUserInfo& userInfo,
        const std::string& oldMid,
        const TMessageBase& message,
        const std::string& fid,
        const TLabelsArgs& labels,
        const THeaders& headers,
        const std::vector<TAttachment>& attachments,
        const std::vector<TMimePart>& parts,
        const TThreadInfo& threadInfo,
        const TStoreParams& params,
        const THandler& handler) = 0;

    virtual void StoreMailish(
        TContextPtr context,
        const std::string& sessionId,
        const TUserInfo& userInfo,
        const TMessageBase& message,
        const std::string& fid,
        const TLabelsArgs& labels,
        const TMaybeFail<TTab>& tab,
        const THeaders& headers,
        const std::vector<TAttachment>& attachments,
        const std::vector<TMimePart>& parts,
        const TThreadInfo& threadInfo,
        const TStoreParams& params,
        uint64_t externalImapId,
        const THandler& handler) = 0;

    virtual macs::ServicePtr GetService(
        TContextPtr context,
        const std::string& sessionId,
        const TUserInfo& userInfo) = 0;


    virtual macs::pg::ConnectionPoolPtr GetConnectionPool() = 0;
};

} // namespace NMdb
