#pragma once

#include <string>
#include <vector>
#include <ctime>

namespace NMdb {

using TLid = std::string;
using TLids = std::vector<TLid>;
using TLabelSymbol = std::string;
using TLabelSymbols = std::vector<TLabelSymbol>;
using TTab = std::string;

enum class ENoSuchFolderAction {
    Fail = 1,
    FallbackToInbox,
    Create
};

struct TLabel {
    std::string Name;
    std::string Type;
    std::string Color;
};

struct THeaders {
    std::string Subject;
    std::string MessageId;
    std::time_t Date = 0;
    std::string To;
    std::string From;
    std::string ReplyTo;
    std::string InReplyTo;
    std::string Cc;
    std::string Bcc;
    std::string ToAndCc;
};

struct TAttachment {
    std::string Hid;
    std::string Name;
    std::string Type;
    std::size_t Size = 0u;
};

struct TMimePart {
    std::string Hid;
    std::string ContentType;
    std::string ContentSubtype;
    std::string Boundary;
    std::string Name;
    std::string Charset;
    std::string Encoding;
    std::string ContentDisposition;
    std::string FileName;
    std::string ContentId;
    std::size_t Offset = 0u;
    std::size_t Length = 0u;
};

struct TFolderCoords {
    std::string Fid;
    std::vector<std::string> Path;
};

inline bool operator==(const TFolderCoords& lhs, const TFolderCoords& rhs) {
    return std::tie(lhs.Fid, lhs.Path) == std::tie(rhs.Fid, rhs.Path);
}

struct TMessageBase {
    std::string Stid;
    std::string FirstLine;
    std::string Pop3Uidl;
    std::time_t ReceivedDate = 0u;
    std::size_t Size = 0u;
    std::size_t OffsetDiff = 0u;
};

struct TUserInfo {
    std::string Uid;
    std::string Suid;
    std::string IpFrom;
};

enum class EThreadsMergeRules {
    Hash,
    References,
    ForceNewThread
};

enum class EThreadsHashNamespaces {
    Subject,
    From
};

struct TThreadHash {
    EThreadsHashNamespaces Ns = EThreadsHashNamespaces::Subject;
    std::string Value = "0";
    std::string Key = "0";
};

struct TThreadLimits {
    std::time_t ReceivedDate = 0;
    unsigned int DaysLimit = 0;
    unsigned int CountLimit = 0;
};

struct TThreadInfo {
    TThreadHash Hash;
    TThreadLimits Limits;
    EThreadsMergeRules MergeRule = EThreadsMergeRules::ForceNewThread;
    std::vector<std::string> ReferenceHashes;
    std::vector<std::string> MessageIds;
    std::string InReplyToHash;
    std::string MessageIdHash;
};

struct TFilterActions {
    TFolderCoords OriginalFolder;
    bool OriginalStoreAsDeleted;
    TLids AddedLids;
    TLabelSymbols AddedSymbols;
};

} // namespace NMdb
