#pragma once

#include "errors.h"
#include "mdb_module.h"

#include <util/generic/algorithm.h>

namespace NMdb {

void UpdateStoreResultWithResolvedLabels(
    macs::ServicePtr db,
    TStoreResult& storeResult,
    std::function<void(boost::system::error_code)> handler)
{
    auto callback = [&storeResult, handler](mail_errors::error_code err, macs::LabelSet allLabels) {
        if (err) {
            return handler(EError::Ok);
        }

        for (const auto& lid: storeResult.Envelope.labels()) {
            if (!AnyOf(storeResult.Labels, [&lid](const auto& resolvedLabel) { return resolvedLabel.Lid == lid; })) {
                if (allLabels.exists(lid)) {
                    const auto& label = allLabels.at(lid);
                    storeResult.Labels.emplace_back(TResolvedLabel{label.lid(), label.symbolicName().title(), label.name()});
                } else {
                    storeResult.Labels.emplace_back(TResolvedLabel{lid, "", ""});
                }
            }
        }

        handler(EError::Ok);
    };

    return db->labels().getAllLabels(callback);
}

} // namespace NMdb
