#pragma once

#include <mail/mdbsave/lib/web/types/common.h>
#include <mail/mdbsave/lib/web/types/reflection/response.h>

#include <yamail/data/serialization/yajl.h>

namespace NMdb::NWeb {

template<typename TResponse>
void Respond(THttpStreamPtr stream, EHttpCode code, TResponse&& response) {
    stream->set_code(code);
    stream->set_content_type("application/json");
    stream->result_body(yamail::data::serialization::toJson(std::forward<TResponse>(response)));
}

}
