#pragma once

#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>

#include <ymod_tvm/module.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/server.h>

namespace NMdb::NWeb {

using EHttpCode = ymod_webserver::codes::code;
using EHttpMethod = ymod_webserver::methods::http_method;
using EHttpReason = ymod_webserver::codes::reason;

using TRequestHeaders = ymod_webserver::header_map_t;
using THttpStreamPtr = ymod_webserver::http::stream_ptr;
using TIoService = boost::asio::io_service;
using TReactor = yplatform::reactor;
using TReactorPtr = std::shared_ptr<TReactor>;
using TTvmModule = ymod_tvm::tvm2_module;
using TTvmGuard = tvm_guard::Guard<TTvmModule>;
using TTvmGuardPtr = std::shared_ptr<TTvmGuard>;
using TYmodWebServer = ymod_webserver::server;
using TYmodWebServerPtr = std::shared_ptr<TYmodWebServer>;

}
