#pragma once

#include <ctime>
#include <optional>
#include <string>
#include <vector>

namespace NMdb::NWeb {

struct THeaderAddress{
    std::string Local;
    std::string Domain;
    std::string DisplayName;
};

struct THeaders {
    std::time_t RecievedDate;
    std::optional<std::time_t> Date;
    std::string Subject;
    std::optional<std::string> MsgId;
    std::optional<std::string> ReplyTo;
    std::optional<std::string> InReplyTo;
    std::vector<THeaderAddress> From;
    std::vector<THeaderAddress> To;
    std::optional<std::vector<THeaderAddress>> Cc;
    std::optional<std::vector<THeaderAddress>> Bcc;
};

}
