#pragma once

#include <mail/mdbsave/lib/mdb/types.h>
#include <mail/mdbsave/lib/web/types/header.h>
#include <mail/mdbsave/lib/web/types/label.h>
#include <mail/mdbsave/lib/web/types/mime_part.h>
#include <mail/mdbsave/lib/web/types/storage.h>
#include <mail/mdbsave/lib/web/types/thread_info.h>

#include <optional>
#include <string>

namespace NMdb::NWeb {

using TRequestLids = std::vector<std::string>;
using TRequestLabelSymbols = std::vector<std::string>;
using TRequestLabels = std::vector<TRequestLabel>;

struct TMessage {
    std::optional<std::string> OldMid;
    std::optional<std::int64_t> ExtImapId;
    std::string Firstline;
    std::optional<std::size_t> Size;
    std::optional<TRequestLids> Lids;
    std::optional<TRequestLabelSymbols> LabelSymbols;
    std::optional<TRequestLabels> Labels;
    std::optional<std::string> Tab;
    TStorage Storage;
    THeaders Headers;
    std::optional<std::vector<TAttachment>> Attachments;
    std::optional<std::vector<TMimePart>> MimeParts;
    TThreadInfo ThreadInfo;
};

}
