#pragma once

#include <mail/mdbsave/lib/web/types/message.h>
#include <mail/mdbsave/lib/web/types/reflection/attachment.h>
#include <mail/mdbsave/lib/web/types/reflection/header.h>
#include <mail/mdbsave/lib/web/types/reflection/label.h>
#include <mail/mdbsave/lib/web/types/reflection/mime_part.h>
#include <mail/mdbsave/lib/web/types/reflection/storage.h>
#include <mail/mdbsave/lib/web/types/reflection/thread_info.h>

#include <yamail/data/reflection/reflection.h>

#include <optional>
#include <string>

YREFLECTION_ADAPT_ADT(NMdb::NWeb::TMessage,
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, old_mid, OldMid)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::int64_t>, ext_imap_id, ExtImapId)
    YREFLECTION_MEMBER_RENAMED(std::string, firstline, Firstline)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::size_t>, size, Size)
    YREFLECTION_MEMBER_RENAMED(std::optional<NMdb::NWeb::TRequestLids>, lids, Lids)
    YREFLECTION_MEMBER_RENAMED(std::optional<NMdb::NWeb::TRequestLabelSymbols>, label_symbols, LabelSymbols)
    YREFLECTION_MEMBER_RENAMED(std::optional<NMdb::NWeb::TRequestLabels>, labels, Labels)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, tab, Tab)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TStorage, storage, Storage)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::THeaders, headers, Headers)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::vector<NMdb::TAttachment>>, attachments, Attachments)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::vector<NMdb::NWeb::TMimePart>>, mime_parts, MimeParts)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TThreadInfo, thread_info, ThreadInfo)
)
