#pragma once

#include <mail/mdbsave/lib/web/types/request.h>
#include <mail/mdbsave/lib/web/types/reflection/actions.h>
#include <mail/mdbsave/lib/web/types/reflection/folders.h>
#include <mail/mdbsave/lib/web/types/reflection/message.h>
#include <mail/mdbsave/lib/web/types/reflection/user.h>

#include <yamail/data/reflection/reflection.h>

YREFLECTION_ADAPT_ADT(NMdb::NWeb::TSaveRequestRcpt,
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TUser, user, User)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TMessage, message, Message)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TRequestFolders, folders, Folders)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TActions, actions, Actions)
    YREFLECTION_MEMBER_RENAMED(std::optional<NMdb::NWeb::TRequestAddedLids>, added_lids, AddedLids)
    YREFLECTION_MEMBER_RENAMED(std::optional<NMdb::NWeb::TRequestAddedSymbols>, added_symbols, AddedSymbols)
    YREFLECTION_MEMBER_RENAMED(bool, imap, Imap)
)

YREFLECTION_ADAPT_ADT(NMdb::NWeb::TSaveRequestRcptNode,
    YREFLECTION_MEMBER_RENAMED(std::string, id, Id)
    YREFLECTION_MEMBER_RENAMED(NMdb::NWeb::TSaveRequestRcpt, rcpt, Rcpt)
)

YREFLECTION_ADAPT_ADT(NMdb::NWeb::TSaveRequest,
    YREFLECTION_MEMBER_RENAMED(std::vector<NMdb::NWeb::TSaveRequestRcptNode>, rcpts, Rcpts)
    YREFLECTION_MEMBER_RENAMED(bool, sync, Sync)
)
