#pragma once

#include <mail/mdbsave/lib/web/types/actions.h>
#include <mail/mdbsave/lib/web/types/folders.h>
#include <mail/mdbsave/lib/web/types/message.h>
#include <mail/mdbsave/lib/web/types/user.h>

#include <optional>
#include <string>

namespace NMdb::NWeb {

using TRequestAddedLids = std::vector<std::string>;
using TRequestAddedSymbols = std::vector<std::string>;

struct TSaveRequestRcpt {
    TUser User;
    TMessage Message;
    TRequestFolders Folders;
    TActions Actions;
    std::optional<TRequestAddedLids> AddedLids;
    std::optional<TRequestAddedSymbols> AddedSymbols;
    bool Imap;
};

struct TSaveRequestRcptNode {
    std::string Id;
    TSaveRequestRcpt Rcpt;
};

struct TSaveRequest {
    std::vector<TSaveRequestRcptNode> Rcpts;
    bool Sync;
};

}
