#pragma once

#include <mail/mdbsave/lib/mdb/mdb_module.h>
#include <mail/mdbsave/lib/web/types/label.h>

#include <optional>
#include <string>
#include <vector>

namespace NMdb::NWeb {

struct TSaveResponseRcpt {
    std::string Uid;
    std::string Status; // ok, perm error, temp error
    std::optional<std::string> Description;
    std::optional<std::string> Mid;
    std::optional<std::string> ImapId;
    std::optional<std::string> Tid;
    std::optional<bool> Duplicate;
    std::optional<TResolvedFolder> Folder;
    std::optional<std::vector<TResponseLabel>> Labels;
};

struct TSaveResponseRcptNode {
    std::string Id;
    TSaveResponseRcpt Rcpt;
};

struct TSaveResponse {
    std::vector<TSaveResponseRcptNode> Rcpts;
};

struct TErrorResponse {
    std::string Error;
    std::string Message;
};

}
