#include "get_header.h"

#include <boost/algorithm/string.hpp>

namespace NMdb::NWeb {

std::optional<std::string> GetHeaderOptional(const TRequestHeaders& headers, const std::string& headerName) {
    const auto& header{headers.find(boost::to_lower_copy(headerName))};
    return (header != headers.end()) ? std::make_optional(header->second) : std::nullopt;
}

}
