#pragma once

#include <mdb/context.h>
#include <web/types/common.h>

#include <gmock/gmock.h>

class THandlerMock {
public:
    THandlerMock() = default;
    THandlerMock(const THandlerMock&) = default;

    MOCK_METHOD(void, Call, (NMdb::TContextPtr, NMdb::NWeb::THttpStreamPtr));

    void operator()(NMdb::TContextPtr context, NMdb::NWeb::THttpStreamPtr stream) {
        Call(std::move(context), std::move(stream));
    }
};
