package ru.yandex.qe.mail.meetings.api.resource;

import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import static ru.yandex.qe.mail.meetings.api.resource.ExportApiService.APPLICATION_JSON_WITH_UTF;

/**
 * @author selivanov 2019-05-24
 */
@Path("/export")
@Produces(APPLICATION_JSON_WITH_UTF)
@Consumes(APPLICATION_JSON_WITH_UTF)
public interface ExportApiService {
    String APPLICATION_JSON_WITH_UTF = MediaType.APPLICATION_JSON + "; " + MediaType.CHARSET_PARAMETER + "=" + "UTF-8";

    @GET
    @Path("events")
    boolean exportEvents(@Nonnull @QueryParam("from") Date from, @Nonnull @QueryParam("to") Date to);

    /**
     * Exports events from date rrange into specified table
     *
     * @param from date
     * @param to   date
     * @param path YT table path
     * @return ticket id
     */
    @GET
    @Path("public")
    String exportPublicEvents(@Nonnull @QueryParam("from") Date from,
                              @Nonnull @QueryParam("to") Date to,
                              @Nonnull @QueryParam("path") String path);

    /**
     * Checks state of export task
     *
     * @param id ticket id
     * @return current status
     */
    @GET
    @Path("status")
    String getStatus(@Nonnull @QueryParam("id") String id);

    @GET
    @Path("resources")
    boolean exportResources();

    @GET
    @Path("declines")
    boolean exportDeclines(@Nonnull @QueryParam("date") Date date);

    @GET
    @Path("declines/top")
    List<String> getTopDeclines(@Nonnull @QueryParam("from") Date from,
                                @Nonnull @QueryParam("to") Date to,
                                @QueryParam("threshold") int threshold);

    @GET
    @Path("declines/user")
    List<String> getDeclinesForUser(@Nonnull @QueryParam("from") Date from,
                                    @Nonnull @QueryParam("to") Date to,
                                    @Nonnull @QueryParam("email") String email);

    @GET
    @Path("events/check/declines")
    List<String> checkResourcesDeclines(@Nonnull @QueryParam("date") Date date);

    @GET
    @Path("events/check/dismissed")
    List<String> checkDismissed(@Nonnull @QueryParam("date") Date date);

    @GET
    @Path("resource/restricted")
    List<String> getRestrictedResources();

    /**
     * Returns organizers of events in specified resources at specified date range
     *
     * @param from      date range start
     * @param to        date range end
     * @param resources comma separated resource list
     * @return event organizers list
     */
    @GET
    @Path("events/resource/organizers")
    Set<String> getOrganizers(@Nonnull @QueryParam("from") Date from,
                              @Nonnull @QueryParam("to") Date to,
                              @Nonnull @QueryParam("resources") String resources);
}
