package ru.yandex.qe.mail.meetings.api.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import ru.yandex.qe.mail.meetings.api.resource.dto.ResourceSearchRequest;
import ru.yandex.qe.mail.meetings.api.resource.dto.ResourceSearchStatusResponse;

/**
 * API for calendar`s frontend
 *
 * @author Stepan Kladikov
 */
@Path("/v2")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public interface MeetingsApiController {
    /**
     * Tries to find resources for event
     * @param request       contain eventId and officeIds for searching
     * @return
     */
    @POST
    @Path("/resources/search/create")
    String findResources(ResourceSearchRequest request);

    @GET
    @Path("/resources/search/status")
    ResourceSearchStatusResponse resourceSearchStatus(@QueryParam("eventId") Integer eventId);
}
