package ru.yandex.qe.mail.meetings.api.resource.dto;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author Sergey Galyamichev
 */
public class CalendarAction {
    public static final String CONTEXT_DELIMITER = ";";

    private int id;
    private Integer eventId;

    private String name;
    private int sequence;
    private String instanceStartTs;
    private ActionType type;
    private Date createDate;
    private Date triggerTime;
    private Date start;

    private Status status;
    private String email;
    private String context;
    private String actionId;
    private String groupId;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSequence() {
        return sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public String getInstanceStartTs() {
        return instanceStartTs;
    }

    public void setInstanceStartTs(String instanceStartTs) {
        this.instanceStartTs = instanceStartTs;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ActionType getType() {
        return type;
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public Integer getEventId() {
        return eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setLogins(List<String> users) {
        context = String.join(CONTEXT_DELIMITER, users );
    }

    public List<String> getLogins() {
        return context != null ? Arrays.asList(context.split(CONTEXT_DELIMITER)) : Collections.emptyList();
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public Date getTriggerTime() {
        return triggerTime;
    }

    public void setTriggerTime(Date triggerTime) {
        this.triggerTime = triggerTime;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getStart() {
        return start;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public CalendarAction copy() {
        CalendarAction copy = new CalendarAction();
        copy.eventId = eventId;

        copy.name = name;
        copy.sequence = sequence;
        copy.instanceStartTs = instanceStartTs;
        copy.type = type;
        copy.createDate = createDate;
        copy.triggerTime = triggerTime;
        copy.start = start;

        copy.status = status;
        copy.email = email;
        copy.context = context;
        copy.actionId = actionId;
        copy.groupId = groupId;
        return copy;
    }

    @Override
    public String toString() {
        return "CalendarAction{" +
                "id=" + id +
                ", eventId=" + eventId +
                ", sequence=" + sequence +
                ", instanceStartTs='" + instanceStartTs + '\'' +
                ", type=" + type +
                ", createDate=" + createDate +
                ", triggerTime=" + triggerTime +
                ", start=" + start +
                ", status=" + status +
                ", email='" + email + '\'' +
                ", context='" + context + '\'' +
                ", actionId='" + actionId + '\'' +
                ", groupId='" + groupId + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CalendarAction that = (CalendarAction) o;

        if (eventId != null ? !eventId.equals(that.eventId) : that.eventId != null) {
            return false;
        }
        if (start != null ? !start.equals(that.start) : that.start != null) {
            return false;
        }
        return email != null ? email.equals(that.email) : that.email == null;
    }

    @Override
    public int hashCode() {
        int result = eventId != null ? eventId.hashCode() : 0;
        result = 31 * result + (start != null ? start.hashCode() : 0);
        result = 31 * result + (email != null ? email.hashCode() : 0);
        return result;
    }
}
