package ru.yandex.qe.mail.analytics.graph;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Job {
    //"j/mailan-job/mailan-207\tdaily\thahn.yt.yandex.net:80": {
//      "allow_inherit_clusters": 1,
//      "external_name": null,
//      "weight": 0.040573528835997595,
//      "is_regular": false,
//      "extra_resources": {},
//      "job_type": "nile",
//      "run_at": "hahn.yt.yandex.net:80",
//      "cluster": {
//        "clusters": [
//          "hahn.yt.yandex.net:80"
//        ],
//        "type": "all"
//      },
//      "user_weight": 50,
//      "category": "from_button",
//      "scale": "daily",
//      "dst": {
//        "//home/mail-logs/m3/input/daily/bs/d-yuid-uid-uuid-channel-pageid-impid-producttype/__ISO_DATE__": 1
//      },
//      "source": "common_protocol_repos",
//      "epoch": 0,
//      "clone": "x/mailan-job/mailan-207",
//      "is_unused": false,
//      "descendants": {
//        "j/mailan-job/mailan-319\tdaily": 1,
//        "j/mailan-job/mailan-479\tweekly": 1,
//        "j/mailan-job/mailan-219\tdaily": 1,
//        "j/mailan-job/mailan-465\tdaily": 2,
//        "j/mailan-job/mailan-270\tweekly": 2,
//        "j/mailan-job/mailan-270\tdaily": 2,
//        "j/mailan-job/mailan-270\tmonthly": 2,
//        "j/mailan-job/mailan-568\tweekly": 2
//      },
//      "start_time": null,
//      "blacklist": {},
//      "job": "j/mailan-job/mailan-207",
//      "ancestors": {},
//      "src": {
//        "//cooked_logs/bs-chevent-cooked-log/1d/__ISO_DATE__": 1
//      },
//      "blacklisted": false,
//      "category_priority": 0,
//      "reports": [],
//      "job_name": "j/mailan-job/mailan-207",
//      "allow_collisions": {
//        "by_dst": [],
//        "by_reports": []
//      },
//      "create_once": 0,
//      "weights": {
//        "1.own_weight": 0,
//        "4.user_weight": 2.062618280740093,
//        "7.normalized_weight": 0.040573528835997595,
//        "6.inherited_weight": 50.079389592386335
//      },
//      "symlinks_dst": [],
//            "raw_cluster": {
//        "clusters": [
//          "hahn.yt.yandex.net:80"
//        ],
//        "type": "all"
//      }
//    },

    @JsonProperty("job_name")
    private String jobName;
    private String job;
    private String scale;
    private String source;
    private Boolean blacklisted;
    @JsonProperty("job_type")
    private String jobType;
    private List<String> reports;
    private Map<String, Integer> src;
    private Map<String, Integer> dst;
    private Map<String, Integer> descendants;

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public Map<String, Integer> getDst() {
        return dst;
    }

    public void setDst(Map<String, Integer> dst) {
        this.dst = dst;
    }

    public Map<String, Integer> getSrc() {
        return src;
    }

    public void setSrc(Map<String, Integer> src) {
        this.src = src;
    }

    public String getScale() {
        return scale;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Boolean getBlacklisted() {
        return blacklisted;
    }

    public void setBlacklisted(Boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public String getJobType() {
        return jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public List<String> getReports() {
        return reports;
    }

    public void setReports(List<String> reports) {
        this.reports = reports;
    }

    public Map<String, Integer> getDescendants() {
        return descendants;
    }

    public void setDescendants(Map<String, Integer> descendants) {
        this.descendants = descendants;
    }
}

