package ru.yandex.qe.mail.meetings;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

import ru.yandex.qe.spring.QeMain;

/**
 * @author selivanov 2019-05-24
 */
@Configuration
@ImportResource({"classpath:spring/application-ctx.xml"})
public class Application extends QeMain {
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(
                (t, e) -> LOG.error("Uncaught Exception in thread {}", t, e)
        );
        if (!StandardCharsets.UTF_8.equals(Charset.defaultCharset())) {
            LOG.error("Default character encoding should be UTF-8 but {}", Charset.defaultCharset());
            System.exit(1);
        }
        new Application().run();
    }
}

