package ru.yandex.qe.mail.meetings.analisys;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Event;
import ru.yandex.qe.mail.meetings.services.calendar.dto.EventDate;
import ru.yandex.qe.mail.meetings.services.calendar.dto.EventUser;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;

/**
 * @author Sergey Galyamichev
 */
public class EventGapsInspectionsBuilder implements EventGapsResultBuilder<InspectionsResult> {
    private final InspectionsResult result = new InspectionsResult();
    private final EventDate event;
    private final Event baseEvent;

    public EventGapsInspectionsBuilder(EventDate event, Event baseEvent) {
        this.event = event;
        this.baseEvent = baseEvent;
    }

    @Override
    public void twoResourcesInOffice(Resource.Info r1, Resource.Info r2) {
        result.addCritical(InspectedItem.critical(event, baseEvent, String.format("Two resources in one office %s and %s", r1.getName(), r2.getName())));
    }

    @Override
    public void organizerIsNull() {
        result.addWarning(InspectedItem.warn(event, baseEvent, "Event has no organizer"));
    }

    @Override
    public void organizersAbsence(EventUser organizer) {
        result.addWarning(InspectedItem.warn(event, baseEvent, organizer, "Organizer will miss the event"));
    }

    @Override
    public void noActiveUsersFound(String rid) {
        result.addCritical(InspectedItem.critical(event, baseEvent, rid, "No users in event resources"));
    }

    @Override
    public void oneUserInResource(String rid) {
        result.addWarning(InspectedItem.warn(event, baseEvent, rid, "Event has only one user in resource"));
    }

    @Override
    public void multiResource(String rid) {
        result.addCritical(InspectedItem.critical(event, baseEvent, rid, "Event has multiple resources and only one user"));
    }

    @Override
    public void probablyEmptyResource(String rid) {
        result.addCritical(InspectedItem.critical(event, baseEvent, rid, "Resource probably will be empty"));
    }

    @Override
    public void resourceUtilizationUnknown(String rid) {
        result.addWarning(InspectedItem.warn(event, baseEvent, rid, "Resource probably will be empty"));
    }

    public InspectionsResult build() {
        return result.isEmpty() ? null : result;
    }
}
