package ru.yandex.qe.mail.meetings.analisys;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Event;
import ru.yandex.qe.mail.meetings.services.calendar.dto.EventDate;
import ru.yandex.qe.mail.meetings.services.calendar.dto.EventUser;

/**
 * DTO to store on YT
 *
 * @author Sergey Galyamichev
 */
public class InspectedItem {
    private final Threshold threshold;
    private final Integer baseEventId;
    private final Integer eventId;
    private final Integer resourceId;
    private final String user;
    private final String resourceEmail;
    private final String message;

    public InspectedItem(Threshold threshold,
                         Integer baseEventId,
                         Integer eventId,
                         Integer resourceId,
                         String user,
                         String resourceEmail,
                         String message) {
        this.threshold = threshold;
        this.baseEventId = baseEventId;
        this.eventId = eventId;
        this.resourceId = resourceId;
        this.user = user;
        this.resourceEmail = resourceEmail;
        this.message = message;
    }

    public Threshold getThreshold() {
        return threshold;
    }

    public Integer getBaseEventId() {
        return baseEventId;
    }

    public Integer getEventId() {
        return eventId;
    }

    public Integer getResourceId() {
        return resourceId;
    }

    public String getUser() {
        return user;
    }

    public String getResourceEmail() {
        return resourceEmail;
    }

    public String getMessage() {
        return message;
    }

    public enum Threshold {
        INFO,
        WARNING,
        CRITICAL
    }

    @Override
    public String toString() {
        return "InspectedItem{" +
                "threshold=" + threshold +
                ", baseEventId=" + baseEventId +
                ", eventId=" + eventId +
                ", resourceId=" + resourceId +
                ", user='" + user + '\'' +
                ", resourceEmail='" + resourceEmail + '\'' +
                ", message='" + message + '\'' +
                '}';
    }

    public static InspectedItem warn(EventDate event, Event baseEvent, String message) {
        return build(Threshold.WARNING, baseEvent, event, message, null, null);
    }

    public static InspectedItem warn(EventDate event, Event baseEvent, EventUser user, String message) {
        return build(Threshold.WARNING, baseEvent, event, message, user.getLogin(), null);
    }

    public static InspectedItem warn(EventDate event, Event baseEvent, String resourceId, String message) {
        return build(Threshold.WARNING, baseEvent, event, message, null, resourceId);
    }

    public static InspectedItem critical(EventDate event, Event baseEvent, EventUser user, String message) {
        return build(Threshold.CRITICAL, baseEvent, event, message, user.getLogin(), null);
    }

    public static InspectedItem critical(EventDate event, Event baseEvent, String message) {
        return build(Threshold.CRITICAL, baseEvent, event, message, null, null);
    }

    public static InspectedItem critical(EventDate event, Event baseEvent, String resourceId, String message) {
        return build(Threshold.CRITICAL, baseEvent, event, message, null, resourceId);
    }

    private static InspectedItem build(Threshold critical, Event baseEvent, EventDate event, String message, String user, String resourceId) {
        return new InspectedItem(critical, baseEvent.getEventId(), event.getEventId(), null, user, resourceId, message);
    }
}
