package ru.yandex.qe.mail.meetings.analisys;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectionsResult {
    private static final Logger LOG = LoggerFactory.getLogger(InspectionsResult.class);

    private Set<InspectedItem> items = new HashSet<>();

    public Set<InspectedItem> getCriticals() {
        return items.stream()
                .filter(item-> item.getThreshold() == InspectedItem.Threshold.CRITICAL)
                .collect(Collectors.toSet());
    }

    void addWarning(InspectedItem warning) {
        items.add(warning);
    }

    void addCritical(InspectedItem critical) {
        LOG.warn(critical.toString());
        items.add(critical);
    }

    boolean isEmpty() {
        return items.isEmpty();
    }

    public void add(InspectionsResult result) {
        items.addAll(result.items);
    }

    public List<InspectedItem> getAll() {
        return new ArrayList<>(items);
    }

    public static InspectionsResult merge(InspectionsResult result, InspectionsResult other) {
        result.add(other);
        return result;
    }

    @Override
    public String toString() {
        return "InspectionsResult{" +
                "items=" + items +
                '}';
    }
}
