package ru.yandex.qe.mail.meetings.booking;

import javax.annotation.Nonnull;

public final class BasicMeetingInfo {
    @Nonnull
    private final String organizer;
    @Nonnull
    private final String meetingName;
    @Nonnull
    private final String meetingDesc;
    private final boolean participantsCanInvite;
    private final boolean participantsCanEdit;
    private final boolean othersCanView;

    public BasicMeetingInfo(
            @Nonnull String organizer,
            @Nonnull String meetingName,
            @Nonnull String meetingDesc,
            boolean participantsCanInvite,
            boolean participantsCanEdit,
            boolean othersCanView) {
        this.organizer = organizer;
        this.meetingName = meetingName;
        this.meetingDesc = meetingDesc;
        this.participantsCanInvite = participantsCanInvite;
        this.participantsCanEdit = participantsCanEdit;
        this.othersCanView = othersCanView;
    }

    @Nonnull
    public String organizer() {
        return organizer;
    }

    @Nonnull
    public String meetingName() {
        return meetingName;
    }

    @Nonnull
    public String meetingDesc() {
        return meetingDesc;
    }

    public boolean participantsCanInvite() {
        return participantsCanInvite;
    }

    public boolean participantsCanEdit() {
        return participantsCanEdit;
    }

    public boolean othersCanView() {
        return othersCanView;
    }

    @Override
    public String toString() {
        return "BasicMeetingInfo{" +
                "organizer='" + organizer + '\'' +
                ", meetingName='" + meetingName + '\'' +
                ", meetingDesc='" + meetingDesc + '\'' +
                ", participantsCanInvite=" + participantsCanInvite +
                ", participantsCanEdit=" + participantsCanEdit +
                ", othersCanView=" + othersCanView +
                '}';
    }
}
