package ru.yandex.qe.mail.meetings.booking;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nonnull;

import org.joda.time.Interval;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;
import ru.yandex.qe.mail.meetings.services.staff.dto.Person;


public interface RoomService {

    Set<Integer> allOfficeIds();

    /**
     * получает список ресурсов "не хуже", чем указанный
     */
    @Nonnull
    List<Resource.Info> roomsWithRestrictions(@Nonnull Resource.Info golden);

    /**
     * аналогично @see `roomsWithRestrictions`, но дополнительно ресурсы сортируются согласно BookintgUtils::fitness
     */
    @Nonnull
    List<Resource.Info> roomsWithRestrictionsAndOrder(@Nonnull Resource.Info golden);

    ResourceWithTimeTable schedule(@Nonnull Resource.Info room, @Nonnull Interval terms);

    /**
     * Возвращает расписание переговорок так, как его видит человек
     * @param person - человек, делающий запрос
     * @param terms - временные ограничения
     * @param offices - список офисов
     * @return переговорка -> расписание
     */
    Map<String, TimeTable> fullScheduleForPerson(@Nonnull Person person, @Nonnull Interval terms, @Nonnull Set<Integer> offices);

    /**
     * Ищет переговорку, привязанную к указанному электронному адресу
     * @param mail
     * @return
     */
    Optional<Resource.Info> byMail(@Nonnull String mail);

    default Map<String, TimeTable> fullScheduleForPerson(@Nonnull Person person, @Nonnull Interval terms) {
        return fullScheduleForPerson(person, terms, allOfficeIds());
    }

    final class ResourceWithTimeTable {
        public final Resource.Info info;
        public final TimeTable timeTable;

        public ResourceWithTimeTable(Resource.Info info, TimeTable timeTable) {
            this.info = info;
            this.timeTable = timeTable;
        }
    }
}
