package ru.yandex.qe.mail.meetings.booking;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import org.joda.time.Duration;
import org.joda.time.Interval;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Intervalable;

public interface TimeTable {
    // сроки на которые составлено расписание
    @Nonnull
    Interval terms();

    // Интревалы времени без встреч
    @Nonnull
    List<Interval> freeIntervals(@Nonnull Duration minDuration);


    // Интервалы времени с поставленными встречами
    @Nonnull
    List<? extends Intervalable> busyIntervalsEx();

    @Nonnull
    default List<Interval> busyIntervals() {
        return busyIntervalsEx()
                .stream()
                .map(ed -> new Interval(
                        ed.getStart().getTime(),
                        ed.getEnd().getTime())
                ).collect(Collectors.toList());
    }

    @Nonnull
    default List<Interval> freeIntervals() {
        return freeIntervals(Duration.standardMinutes(0));
    }
}
