package ru.yandex.qe.mail.meetings.booking.dto;

import java.util.Collections;
import java.util.List;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Repetition;


public final class FullSearchResult {
    private final boolean isRegular;
    private final SearchResult regular;
    private final Repetition repetition;
    private final List<SearchResult> additional;
    private final MissingReason reason;

    public FullSearchResult(boolean isRegular, SearchResult regular, Repetition repetition, List<SearchResult> additional, MissingReason reason) {
        this.isRegular = isRegular;
        this.regular = regular;
        this.repetition = repetition;
        this.additional = Collections.unmodifiableList(additional);
        this.reason = reason;
    }

    public static FullSearchResult empty(MissingReason reason) {
        return new FullSearchResult(false, null, null, Collections.emptyList(), reason);
    }

    public static FullSearchResult emptyRegular(MissingReason reason) {
        return new FullSearchResult(true, null, null, Collections.emptyList(), reason);
    }

    public static FullSearchResult of(SearchResult result) {
        return new FullSearchResult(false, null, null, List.of(result), null);
    }

    public static FullSearchResult regularOf(SearchResult regular, Repetition repetition, List<SearchResult> result) {
        return new FullSearchResult(true, regular, repetition, result, null);
    }

    public boolean isEmpty() {
        return regular == null && additional.isEmpty();
    }

    public boolean isRegular() {
        return isRegular;
    }

    public boolean isValid() {
        return (isRegular && (regular != null && repetition != null)) || (!isRegular && !additional.isEmpty());
    }

    public SearchResult regular() {
        return regular;
    }

    public Repetition repetition() {
        return repetition;
    }

    public List<SearchResult> additional() {
        return additional;
    }

    public MissingReason missingReason() {
        return reason;
    }

    public enum MissingReason {
        PERSON_HAVE_NO_INTERSECTION,
        NO_OFFICE,
        TIME_RESTRICTIONS_ERROR,
        NO_FREE_ROOMS,
        REGULAR_BOOKING_UNAVAILABLE,
        API_INTERRACTION_ERROR,
        INTERNAL_ERROR,
    }

    @Override
    public String toString() {
        return "FullSearchResult{" +
                "isRegular=" + isRegular +
                ", regular=" + regular +
                ", repetition=" + repetition +
                ", additional=" + additional +
                ", reason=" + reason +
                '}';
    }
}
