package ru.yandex.qe.mail.meetings.booking.dto;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import org.joda.time.Interval;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;


public final class SearchResult {
    private final Set<Integer> offices;
    private List<Resource.Info> rooms;
    private final Interval interval;

    public SearchResult(Set<Integer> offices, List<Resource.Info> rooms, Interval interval) {
        this.offices = Collections.unmodifiableSet(offices);
        this.rooms = Collections.unmodifiableList(rooms);
        this.interval = interval;
    }

    public Set<Integer> offices() {
        return offices;
    }

    public List<Resource.Info> rooms() {
        return rooms;
    }

    public Interval interval() {
        return interval;
    }

    public Set<Integer> missingOffices() {
        var missing = new TreeSet<>(offices);
        rooms.forEach(r -> {
            missing.remove(r.getOfficeId());
        });

        return missing;
    }

    public static SearchResult empty(@Nonnull List<OfficeRequirements> officeRequirements, @Nonnull Interval interval) {
        return new SearchResult(
                officeRequirements.stream().map(or -> or.officeId).collect(Collectors.toSet()),
                Collections.emptyList(),
                interval
        );
    }

    @Override
    public String toString() {
        return "SearchResult{" +
                "offices=" + offices +
                ", rooms=" + rooms.stream().map(Resource.Info::getName).collect(Collectors.joining(",")) +
                ", interval=" + interval +
                '}';
    }
}
