package ru.yandex.qe.mail.meetings.config;

import org.apache.commons.lang3.CharEncoding;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

/**
 * All email notification settings
 *
 * @author Sergey Galiamichev
 */
@Configuration("notConfig")
@PropertySource(value = "classpath:properties/context.properties", encoding = CharEncoding.UTF_8)
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "notifications")
public class NotificationConfiguration {
    private String from;
    private String replyTo;
    private String notFoundSubject;
    private String searchStarted;
    private String resourceSwap;
    private String gapsSubject;
    private DeclinedConfiguration declined;
    private DismissedConfiguration dismissed;

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getNotFoundSubject() {
        return notFoundSubject;
    }

    public void setNotFoundSubject(String notFoundSubject) {
        this.notFoundSubject = notFoundSubject;
    }

    public String getSearchStarted() {
        return searchStarted;
    }

    public void setSearchStarted(String searchStarted) {
        this.searchStarted = searchStarted;
    }

    public DeclinedConfiguration getDeclined() {
        return declined;
    }

    public void setGapsSubject(String gapsSubject) {
        this.gapsSubject = gapsSubject;
    }

    public String getGapsSubject() {
        return gapsSubject;
    }

    public void setDeclined(DeclinedConfiguration declined) {
        this.declined = declined;
    }

    public DismissedConfiguration getDismissed() {
        return dismissed;
    }

    public void setDismissed(DismissedConfiguration dismissed) {
        this.dismissed = dismissed;
    }

    public String getResourceSwap() {
        return resourceSwap;
    }

    public void setResourceSwap(String resourceSwap) {
        this.resourceSwap = resourceSwap;
    }
}
