package ru.yandex.qe.mail.meetings.cron.actions;

import java.util.List;

import javax.inject.Inject;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.api.resource.dto.CalendarAction;
import ru.yandex.qe.mail.meetings.api.resource.dto.Status;
import ru.yandex.qe.mail.meetings.rooms.dao.SentEmailsDao;
import ru.yandex.qe.mail.meetings.services.calendar.dto.faults.CalendarException;
import ru.yandex.qe.mail.meetings.services.calendar.dto.faults.Error;

/**
 * @author Sergey Galyamichev
 */
@Component
public class DoActionsJob implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(DoActionsJob.class);
    @Inject
    private SentEmailsDao sentEmailsDao;
    @Inject
    private ActionsRunner runner;

    @Override
    public void execute(JobExecutionContext context) {
        LOG.info("DoActionsJob has been started...");
        List<CalendarAction> actions = sentEmailsDao.getExpiredPendingActions(context.getFireTime());
        for (CalendarAction action : actions) {
            try {
                Status status = runner.perform(action);
                updateAction(action, status);
            } catch (CalendarException e) {
                if (Error.EVENT_MODIFIED.equals(e.getName()) || Error.EVENT_NOT_FOUND.equals(e.getName())) {
                    updateAction(action, Status.OUTDATED);
                    LOG.warn("Action skipped", e);
                } else {
                    updateAction(action, Status.FAILED);
                    LOG.error("Can't process message", e);
                }
            }
        }
        LOG.info("DoActionsJob has been done.");
    }

    private void updateAction(CalendarAction action, Status status) {
        boolean updated = sentEmailsDao.updateAction(action.getActionId(), status);
        if (!updated) {
            LOG.warn("Failed to update action {} for event {}", action.getId(), action.getEventId());
        }
    }
}
