package ru.yandex.qe.mail.meetings.cron.declines;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import freemarker.template.Configuration;
import org.apache.commons.lang3.CharEncoding;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import ru.yandex.qe.mail.meetings.blamer.DeclineEvent;
import ru.yandex.qe.mail.meetings.blamer.DeclineEvents;
import ru.yandex.qe.mail.meetings.config.NotificationConfiguration;
import ru.yandex.qe.mail.meetings.cron.AbstractMessageBuilder;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.utils.DateRange;

/**
 * @author Sergey Galyamichev
 */
@Component
public class DeclinedEventMessageBuilder extends AbstractMessageBuilder {
    private static final String TEMPLATE = "decline_email.ftl";


    public DeclinedEventMessageBuilder(Configuration configuration,
                                       StaffClient staffClient,
                                       NotificationConfiguration notConfig) {
        super(configuration, staffClient, notConfig);
    }

    void prepareMessage(MimeMessage mimeMessage, DeclineEvents user, DateRange range, List<DeclineEvent> events) throws MessagingException {
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, CharEncoding.UTF_8);
        prepareMessageHeaders(message, user.getEmail(), notConfig.getDeclined().getCc());
        message.setSubject(getLogin(user.getEmail()) + "@ " + notConfig.getDeclined().getSubject());
        message.setText(buildBody(user, range, events), true);
    }

    private String buildBody(DeclineEvents event, DateRange range, List<DeclineEvent> events) throws MessagingException {
        try {
            Map<String, Object> valuesMap = new HashMap<>();
            valuesMap.put("from", DF_HOLDER.get().format(range.getFrom()));
            valuesMap.put("to", DF_HOLDER.get().format(range.getTo()));
            valuesMap.put(NAME, event.getName());
            valuesMap.put("count", String.valueOf(event.getCount()));
            valuesMap.put("events", events);
            return FreeMarkerTemplateUtils.processTemplateIntoString(configuration.getTemplate(TEMPLATE), valuesMap);
        } catch (Exception e) {
            throw new MessagingException("Unable to build body", e);
        }
    }
}
