package ru.yandex.qe.mail.meetings.cron.declines;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.blamer.DeclineEvent;
import ru.yandex.qe.mail.meetings.blamer.DeclineEvents;
import ru.yandex.qe.mail.meetings.blamer.DeclinedEventsDao;
import ru.yandex.qe.mail.meetings.utils.DateRange;
import ru.yandex.qe.mail.meetings.ws.CalendarFacade;

/**
 * @author Sergey Galyamichev
 */
@Component
public class DeclinedEventProvider {
    private final DeclinedEventsDao eventDao;
    private final CalendarFacade calendarFacade;

    public DeclinedEventProvider(DeclinedEventsDao eventDao, CalendarFacade calendarFacade) {
        this.eventDao = eventDao;
        this.calendarFacade = calendarFacade;
    }

    List<DeclineEvents> getDeclineEvent(DateRange lastWeek, int threshold) {
        return eventDao.getDeclineEvent(lastWeek, threshold);
    }

    List<DeclineEvent> getEventsList(DeclineEvents event, DateRange range) {
        List<DeclineEvent> declineEvent = eventDao.getDeclineEvent(range, event.getEmail()).stream()
                .filter(e -> event.getName().equals(e.getName()))
                .collect(Collectors.toList());
        Set<Integer> foundEvents = calendarFacade.getBrief(declineEvent, DeclineEvent::getEventId).keySet();
        return declineEvent.stream()
                .map(e -> patchEvent(e, foundEvents))
                .collect(Collectors.toList());
    }

    private DeclineEvent patchEvent(DeclineEvent e, Set<Integer> foundEvents) {
        e.setDeleted(!foundEvents.contains(e.getEventId()));
        e.setResourceName(getResourceName(e));
        return e;
    }

    private String getResourceName(DeclineEvent e) {
        return e.getResourceName() == null ? "email = " + e.getResourceEmail() + "?" : e.getResourceName();
    }
}
