package ru.yandex.qe.mail.meetings.cron.dismissed;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import freemarker.template.Configuration;
import org.apache.commons.lang3.CharEncoding;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import ru.yandex.qe.mail.meetings.api.resource.dto.CalendarAction;
import ru.yandex.qe.mail.meetings.config.NotificationConfiguration;
import ru.yandex.qe.mail.meetings.cron.AbstractMessageBuilder;
import ru.yandex.qe.mail.meetings.services.calendar.dto.User;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.utils.DateRange;

/**
 * @author Sergey Galyamichev
 */
@Component
public class DismissedAttendeeMessageBuilder extends AbstractMessageBuilder {
    private static final String TEMPLATE = "dismissed_users.ftl";

    public DismissedAttendeeMessageBuilder(Configuration configuration,
                                           StaffClient staffClient,
                                           NotificationConfiguration notConfig) {
        super(configuration, staffClient, notConfig);
    }

    void prepareMessage(MimeMessage mimeMessage, DateRange range, User user, List<CalendarAction> actions) throws MessagingException {
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, CharEncoding.UTF_8);
        prepareMessageHeaders(message, user.getEmail(), notConfig.getDismissed().getCc());
        message.setSubject(getLogin(user.getEmail()) + "@ " + notConfig.getDismissed().getSubject());
        actions.sort(Comparator.comparing(CalendarAction::getStart).thenComparingInt(CalendarAction::getEventId));
        message.setText(buildBody(user, range, actions), true);
    }

    private String buildBody(User event, DateRange range,  List<CalendarAction> actions) throws MessagingException {
        try {
            Map<String, Object> valuesMap = new HashMap<>();
            valuesMap.put("from", DF_HOLDER.get().format(range.getFrom()));
            valuesMap.put("to", DF_HOLDER.get().format(range.getTo()));
            valuesMap.put(NAME, event.getName());
            valuesMap.put("count", actions.size());
            valuesMap.put("days", notConfig.getDismissed().getDaysToAction());
            valuesMap.put("actions", actions);
            return FreeMarkerTemplateUtils.processTemplateIntoString(configuration.getTemplate(TEMPLATE), valuesMap);
        } catch (Exception e) {
            throw new MessagingException("Unable to build body", e);
        }
    }
}
