package ru.yandex.qe.mail.meetings.cron.dismissed;

import java.util.Set;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Lazy list from comma separated strings
 *
 * @author Sergey Galyamichev
 */
@Component
public class LoginWhitelist {
    private final String luckyLoginsStr;
    private Set<String> luckyLogins;

    public LoginWhitelist(@Value("${all.events.allowed.logins}") String luckyLoginsStr) {
        this.luckyLoginsStr = luckyLoginsStr;
    }

    public boolean isLucky(String login) {
        if (luckyLoginsStr == null || luckyLoginsStr.isEmpty()) {
            return true;
        }
        if (luckyLogins == null) {
            luckyLogins = Set.of(luckyLoginsStr.split(","));
        }
        return luckyLogins.contains(login);
    }
}
