package ru.yandex.qe.mail.meetings.cron.dump;

import java.util.Calendar;

import javax.inject.Inject;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.mail.meetings.api.resource.ExportApiService;

/**
 * The job makes a snapshot for today and yesterday events and also search declined by display meetings
 * for a previous day
 *
 * @author Sergey Galiamichev
 */
public class CronExporter implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(CronExporter.class);

    @Inject
    private ExportApiService exportApiService;

    @Override
    public void execute(JobExecutionContext context) {
        LOG.info("CronExporter has been started...");
        Calendar calendar = Calendar.getInstance();
        exportApiService.exportResources();
        exportApiService.exportEvents(calendar.getTime(), calendar.getTime());
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        exportApiService.exportEvents(calendar.getTime(), calendar.getTime());
        exportApiService.exportDeclines(calendar.getTime());
        LOG.info("CronExporter has been done.");
    }
}
