package ru.yandex.qe.mail.meetings.cron.forecast;

import java.util.Date;

import javax.inject.Inject;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.qe.mail.meetings.analisys.InspectionsResult;
import ru.yandex.qe.mail.meetings.services.calendar.DateParameterConverterProvider;
import ru.yandex.qe.mail.meetings.storage.CalendarStorage;
import ru.yandex.qe.mail.meetings.utils.DateRange;

/**
 * @author Sergey Galyamichev
 */
public class DeclinesForecastJob implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(DeclinesForecastJob.class);
    private static final String FORECAST = "/forecast/";
    @Inject
    private PossiblyDeclinedEventProvider provider;
    @Inject
    private CalendarStorage storage;
    @Value("${calendar.yt.root.path}")
    private String ytPath;

    @Override
    public void execute(JobExecutionContext context) {
        LOG.info("DeclinesForecastJob has been started...");
        Date tomorrow = DateRange.tomorrow(context.getFireTime());
        InspectionsResult result = provider.checkResourcesDeclines(tomorrow);
        String path = ytPath + FORECAST + DateParameterConverterProvider.CONVERTER.toString(tomorrow);
        storage.storeForecast(path, result.getAll());
        LOG.info("DeclinesForecastJob has been done.");
    }
}
