package ru.yandex.qe.mail.meetings.cron.forecast;

import java.util.Date;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.analisys.InspectionsResult;
import ru.yandex.qe.mail.meetings.analisys.UserCheck;
import ru.yandex.qe.mail.meetings.services.gaps.GapApi;
import ru.yandex.qe.mail.meetings.services.gaps.dto.Gaps;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.ws.CalendarFacade;

/**
 * @author Sergey Galyamichev
 */
@Component
public class PossiblyDeclinedEventProvider {
    private final GapApi gapApi;
    private final StaffClient staffClient;
    private final CalendarFacade calendarFacade;

    public PossiblyDeclinedEventProvider(GapApi gapApi, StaffClient staffClient, CalendarFacade calendarFacade) {
        this.gapApi = gapApi;
        this.staffClient = staffClient;
        this.calendarFacade = calendarFacade;
    }

    public InspectionsResult checkResourcesDeclines(@Nonnull Date date) {
        Gaps gaps = gapApi.exportGaps();
        UserCheck.Bulk userCheck = new UserCheck.Bulk(staffClient);
        return calendarFacade.checkEvents(date, date, userCheck, gaps.getPersons()).stream()
                .reduce(new InspectionsResult(), InspectionsResult::merge);
    }
}
