package ru.yandex.qe.mail.meetings.cron.scanner;

import java.util.HashMap;
import java.util.Map;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import freemarker.template.Configuration;
import org.apache.commons.lang3.CharEncoding;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import ru.yandex.qe.mail.meetings.api.resource.dto.CalendarAction;
import ru.yandex.qe.mail.meetings.config.NotificationConfiguration;
import ru.yandex.qe.mail.meetings.cron.AbstractMessageBuilder;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.services.staff.dto.Person;

/**
 * @author Sergey Galyamichev
 */
@Component
public class ScanTimeoutMessageBuilder extends AbstractMessageBuilder {
    private static final String TEMPLATE = "scan_timeout.ftl";

    public ScanTimeoutMessageBuilder(Configuration configuration, StaffClient staffClient, NotificationConfiguration notConfig) {
        super(configuration, staffClient, notConfig);
    }

    void prepareMessage(MimeMessage mimeMessage, CalendarAction action) throws MessagingException {
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, CharEncoding.UTF_8);
        Person person = staffClient.getByLogin(getLogin(action.getEmail()));
        prepareMessageHeaders(message, action.getEmail(), null);
        message.setSubject(notConfig.getNotFoundSubject());
        message.setText(buildBody(person, action), true);
    }

    private String buildBody(Person person, CalendarAction action) throws MessagingException {
        try {
            Map<String, Object> valuesMap = new HashMap<>();
            valuesMap.put(NAME, person.getName().toString(person.getLanguage().getUi()));
            valuesMap.put("action", action);
            return FreeMarkerTemplateUtils.processTemplateIntoString(configuration.getTemplate(TEMPLATE), valuesMap);
        } catch (Exception e) {
            throw new MessagingException("Unable to build body", e);
        }
    }
}
