package ru.yandex.qe.mail.meetings.domain;

import java.util.List;

import ru.yandex.qe.mail.meetings.services.calendar.dto.EventUser;

/**
 * Entity object to be written to YT
 */
public class EventRecord {
    private int eventId;
    private int officeId;
    private int resourceId;
    private String startTs;
    private String endTs;
    private EventUser organizer;
    private long attendees;
    private List<EventUser> attendeesList;

    public EventRecord(int eventId, int officeId, int resourceId, String startTs, String endTs, EventUser organizer,
                       long attendees, List<EventUser> attendeesList) {
        this.eventId = eventId;
        this.officeId = officeId;
        this.resourceId = resourceId;
        this.startTs = startTs;
        this.endTs = endTs;
        this.organizer = organizer;
        this.attendees = attendees;
        this.attendeesList = attendeesList;
    }

    public int getEventId() {
        return eventId;
    }

    public int getOfficeId() {
        return officeId;
    }

    public int getResourceId() {
        return resourceId;
    }

    public String getStartTs() {
        return startTs;
    }

    public String getEndTs() {
        return endTs;
    }

    public EventUser getOrganizer() {
        return organizer;
    }

    public long getAttendees() {
        return attendees;
    }

    public List<EventUser> getAttendeesList() {
        return attendeesList;
    }
}
