package ru.yandex.qe.mail.meetings.rooms;

import java.util.List;

import javax.inject.Named;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import ru.yandex.qe.mail.meetings.ws.RestrictedResource;

/**
 * @author Sergey Galyamichev
 */
@Repository
public class ResourceDao {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDao.class);

    // robot has no access to tmp folder
    private static final String TMP_FOLDER = "PRAGMA yt.TmpFolder = '//home/calendar/corp/raw/tmp'; ";
    private static final String DISABLE_CACHE =
            "PRAGMA yt.QueryCacheMode='disable'; " +
            "PRAGMA yt.ReleaseTempData='immediate'; " +
            "PRAGMA yt.AutoMerge='disabled'; ";


    private NamedParameterJdbcTemplate jdbcTemplate;

    @Autowired
    public ResourceDao(@Named("ytDataSource") DataSource dataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public List<RestrictedResource> getResources() {
        LOG.debug("In getResources()...");
        String sql = TMP_FOLDER +
                DISABLE_CACHE +
                "SELECT "+
                    "rca.id AS id, " +
                    "WeakField(rca.access_group, 'String') AS access_group, " +
                    "WeakField(rca.name, 'String') AS name, " +
                    "WeakField(r.center_id, 'String') AS center_id, " +
                    "WeakField(r.city_name_en, 'String') AS city_name_en, " +
                    "WeakField(rca.protection_message, 'String') AS protection_message, " +
                    "WeakField(rca.type, 'String') AS type, " +
                    "WeakField(rca.uids, 'String') AS uids, " +
                    "WeakField(rca.urls, 'String') AS urls, " +
                    "WeakField(r.exists_on_staff, 'String') AS exists_on_staff, " +
                    "WeakField(r.r_is_active, 'String') AS r_is_active, " +
                    "WeakField(r.display_last_ping_ts, 'String') AS display_last_ping_ts "+
                "FROM " +
                    "`//home/calendar/corp/raw/resource-can-access` AS rca " +
                "LEFT JOIN " +
                    "`//home/calendar/corp/raw/resources` AS r " +
                "ON " +
                    "rca.id = r.r_id";
        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<>(RestrictedResource.class));
    }
}
