package ru.yandex.qe.mail.meetings.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

import ru.yandex.qe.mail.meetings.security.filters.BlackBoxAuthenticationFilter;
import ru.yandex.qe.mail.meetings.security.filters.TvmSecurityFilter;
import ru.yandex.qe.mail.meetings.security.providers.OauthAuthenticationProvider;
import ru.yandex.qe.mail.meetings.security.providers.SessionAuthenticationProvider;
import ru.yandex.qe.mail.meetings.security.providers.TvmAuthenticationProvider;

/**
 * @author Sergey Galyamichev
 */
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class YandexWebSecurityConfigurerAdapter extends WebSecurityConfigurerAdapter {
    @Autowired
    private OauthAuthenticationProvider oauthAuthenticationProvider;
    @Autowired
    private TvmAuthenticationProvider tvmAuthenticationProvider;
    @Autowired
    private SessionAuthenticationProvider sessionAuthenticationProvider;

    @Override
    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider(oauthAuthenticationProvider)
                .authenticationProvider(tvmAuthenticationProvider)
                .authenticationProvider(sessionAuthenticationProvider);
    }

    @Bean
    @Override
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Override
    public void configure(WebSecurity web) {
        web.ignoring().antMatchers("/unistat")
                .antMatchers("/ping")
                .antMatchers("/api/version")
                .antMatchers("/telemetry/healthcheck")
                .antMatchers("/api/form/validate")
                .regexMatchers("/api/.*")
                .regexMatchers("/api/export.*")
                .regexMatchers("/telemetry.*");
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.addFilterAfter(new BlackBoxAuthenticationFilter(), BasicAuthenticationFilter.class)
                .addFilterAfter(new TvmSecurityFilter(), BasicAuthenticationFilter.class)
                .authorizeRequests()
                .anyRequest().authenticated()
                .and()
                .httpBasic();
    }

}

