package ru.yandex.qe.mail.meetings.security.filters;

import java.util.List;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import ru.yandex.qe.mail.meetings.security.tokens.UserAuthentication;
import ru.yandex.qe.mail.meetings.services.tvm.TvmDaemonClient;

/**
 * @author Sergey Galyamichev
 */
public class TvmClientFilter implements ClientRequestFilter {
    private String destination;
    private TvmDaemonClient tvmDaemonClient;
    private boolean userTicket;

    public TvmClientFilter(String destination, TvmDaemonClient tvmDaemonClient, boolean userTicket) {
        this.destination = destination;
        this.tvmDaemonClient = tvmDaemonClient;
        this.userTicket = userTicket;
    }

    @Override
    public void filter(ClientRequestContext requestContext) {
        String serviceTicket = tvmDaemonClient.getTickets(List.of(destination), null).get(destination).getTicket();
        requestContext.getHeaders().add(TvmDaemonClient.SERVICE_TICKET_HEADER, serviceTicket);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (userTicket && authentication instanceof UserAuthentication && authentication.getCredentials() != null) {
            requestContext.getHeaders().add(TvmDaemonClient.USER_TICKET_HEADER, authentication.getCredentials().toString());
        }
    }
}
