package ru.yandex.qe.mail.meetings.security.filters;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.qe.mail.meetings.security.tokens.TvmAuthenticationToken;
import ru.yandex.qe.mail.meetings.services.tvm.TvmDaemonClient;

/**
 * @author Sergey Galyamichev
 */
public class TvmSecurityFilter extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest request,
                                    HttpServletResponse response,
                                    FilterChain filterChain) throws ServletException, IOException
    {
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            SecurityContextHolder.getContext().setAuthentication(createAuthentication(request));
        }

        filterChain.doFilter(request, response);
    }

    private Authentication createAuthentication(HttpServletRequest request) {
        String tvmHeader = request.getHeader(TvmDaemonClient.USER_TICKET_HEADER);
        if (tvmHeader != null) {
            logger.debug("Requesting authentication with tvm ticket");
            return new TvmAuthenticationToken(tvmHeader);
        }
        return null;
    }
}
