package ru.yandex.qe.mail.meetings.security.providers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.security.tokens.OAuthAuthenticationToken;
import ru.yandex.qe.mail.meetings.security.tokens.UserAuthentication;
import ru.yandex.qe.mail.meetings.services.blackbox.BlackBoxService;
import ru.yandex.qe.mail.meetings.services.blackbox.dto.OAuthRequest;
import ru.yandex.qe.mail.meetings.services.blackbox.dto.User;

/**
 * Converts OAuth token to user authentication
 *
 * @author Sergey Galyamichev
 */
@Component
public class OauthAuthenticationProvider implements AuthenticationProvider {
    protected final Log logger = LogFactory.getLog(getClass());

    private final BlackBoxService blackBoxService;
    private final TvmParamsProvider tvmParamsProvider;

    public OauthAuthenticationProvider(BlackBoxService blackBoxService, TvmParamsProvider tvmParamsProvider) {
        this.blackBoxService = blackBoxService;
        this.tvmParamsProvider = tvmParamsProvider;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!supports(authentication.getClass())) {
            return null;
        }
        OAuthAuthenticationToken token = (OAuthAuthenticationToken) authentication;
        try {
            OAuthRequest request = new OAuthRequest();
            request.setUserip(token.getPrincipal());
            request.setOauthToken(token.getCredentials());
            tvmParamsProvider.update(request);
            final User oauth = blackBoxService.oauth(request);
            return UserAuthentication.from(oauth);
        } catch (Exception e) {
            logger.error("Bad request for ip: " + token.getPrincipal(), e);
            throw new BadCredentialsException("Failed authenticate" + e.getMessage());
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return OAuthAuthenticationToken.class.isAssignableFrom(authentication);
    }
}
