package ru.yandex.qe.mail.meetings.security.providers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.security.tokens.SessionAuthenticationToken;
import ru.yandex.qe.mail.meetings.security.tokens.UserAuthentication;
import ru.yandex.qe.mail.meetings.services.blackbox.BlackBoxService;
import ru.yandex.qe.mail.meetings.services.blackbox.dto.SessionIdRequest;
import ru.yandex.qe.mail.meetings.services.blackbox.dto.User;

/**
 * Converts session cookie to user authentication
 *
 * @author Sergey Galyamichev
 */
@Component
public class SessionAuthenticationProvider implements AuthenticationProvider {
    protected final Log logger = LogFactory.getLog(getClass());
    private final BlackBoxService blackBoxService;
    private final TvmParamsProvider tvmParamsProvider;

    public SessionAuthenticationProvider(BlackBoxService blackBoxService, TvmParamsProvider tvmParamsProvider) {
        this.blackBoxService = blackBoxService;
        this.tvmParamsProvider = tvmParamsProvider;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!supports(authentication.getClass())) {
            return null;
        }
        SessionAuthenticationToken token = (SessionAuthenticationToken) authentication;
        try {
            SessionIdRequest request = new SessionIdRequest();
            request.setUserip(token.getPrincipal());
            request.setSessionid(token.getCredentials());
            request.setHost("https://passport.yandex-team.ru");
            tvmParamsProvider.update(request);
            final User sessionid = blackBoxService.sessionid(request);
            return UserAuthentication.from(sessionid);
        } catch (Exception e) {
            logger.error("Bad request for ip: " + token.getPrincipal(), e);
            throw new SessionAuthenticationException("Failed authenticate" + e.getMessage());
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return SessionAuthenticationToken.class.isAssignableFrom(authentication);
    }
}
