package ru.yandex.qe.mail.meetings.security.providers;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.security.tokens.TvmAuthenticationToken;
import ru.yandex.qe.mail.meetings.security.tokens.UserAuthentication;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.services.tvm.TvmDaemonClient;
import ru.yandex.qe.mail.meetings.services.tvm.dto.UserTicket;

/**
 * @author Sergey Galyamichev
 */
@Component
public class TvmAuthenticationProvider implements AuthenticationProvider {
    private TvmDaemonClient tvmDaemonClient;
    private StaffClient staffClient;

    public TvmAuthenticationProvider(TvmDaemonClient tvmDaemonClient, StaffClient staffClient) {
        this.tvmDaemonClient = tvmDaemonClient;
        this.staffClient = staffClient;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!supports(authentication.getClass())) {
            return null;
        }
        UserTicket ticket = tvmDaemonClient.checkUser(authentication.getPrincipal().toString(), null);
        String login = staffClient.getByUid(ticket.getDefaultUid().toString()).getLogin();
        return new UserAuthentication(ticket.getDefaultUid().toString(), login, authentication.getPrincipal().toString());
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return TvmAuthenticationToken.class.isAssignableFrom(authentication);
    }
}
