package ru.yandex.qe.mail.meetings.security.providers;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.qe.mail.meetings.security.filters.BlackBoxAuthenticationFilter;
import ru.yandex.qe.mail.meetings.services.blackbox.dto.BlackBoxRequest;
import ru.yandex.qe.mail.meetings.services.tvm.TvmDaemonClient;
import ru.yandex.qe.mail.meetings.services.tvm.dto.TvmTicket;

/**
 * @author Sergey Galyamichev
 */
@Component
public class TvmParamsProvider {
    private final boolean tvmEnabled;
    private final TvmDaemonClient tvmDaemonClient;

    public TvmParamsProvider(TvmDaemonClient tvmDaemonClient, @Value("${tvm.enabled}") boolean tvmEnabled) {
        this.tvmEnabled = tvmEnabled;
        this.tvmDaemonClient = tvmDaemonClient;
    }

    public void update(BlackBoxRequest request) {
        if (tvmEnabled) {
            Optional<String> serviceTicket = getTicket();
            if (serviceTicket.isPresent()) {
                request.setUserTicket(tvmEnabled);
                request.setServiceTicket(serviceTicket.get());
            }
        }
    }

    private Optional<String> getTicket() {
        return Optional.of(tvmDaemonClient.getTickets(List.of(BlackBoxAuthenticationFilter.BLACKBOX), null)
                .get(BlackBoxAuthenticationFilter.BLACKBOX))
                .map(TvmTicket::getTicket);
    }
}
