package ru.yandex.qe.mail.meetings.security.tokens;

import org.springframework.security.authentication.AbstractAuthenticationToken;

/**
 * @author Sergey Galyamichev
 */
public class OAuthAuthenticationToken extends AbstractAuthenticationToken {
    private final String userIp;
    private final String token;

    public OAuthAuthenticationToken(String userIp, String token) {
        super(null);
        this.userIp = userIp;
        this.token = token;
    }

    @Override
    public String getCredentials() {
        return token;
    }

    @Override
    public String getPrincipal() {
        return userIp;
    }
}
