package ru.yandex.qe.mail.meetings.security.tokens;

import org.springframework.security.authentication.AbstractAuthenticationToken;

/**
 * @author Sergey Galyamichev
 */
public class SessionAuthenticationToken extends AbstractAuthenticationToken {
    private final String userIp;
    private final String sessionId;
    private final String sslSessionId;

    public SessionAuthenticationToken(String userIp, String sessionId, String sslSessionId) {
        super(null);
        this.userIp = userIp;
        this.sessionId = sessionId;
        this.sslSessionId = sslSessionId;
    }

    @Override
    public String getCredentials() {
        return sessionId;
    }

    @Override
    public String getPrincipal() {
        return userIp;
    }

    public String getSslSessionId() {
        return sslSessionId;
    }
}
