package ru.yandex.qe.mail.meetings.security.tokens;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;

import ru.yandex.qe.mail.meetings.services.blackbox.dto.User;

/**
 * @author Sergey Galyamichev
 */
public class UserAuthentication extends AbstractAuthenticationToken {
    private static final Logger LOG = LoggerFactory.getLogger(UserAuthentication.class);

    private final String uid;
    private final String login;
    private final String ticket;

    public UserAuthentication(String uid, String login, String ticket) {
        super(null);
        this.uid = uid;
        this.login = login;
        this.ticket = ticket;
        setAuthenticated(true);
    }

    public String getUid() {
        return uid;
    }

    @Override
    public String getPrincipal() {
        return login;
    }

    @Override
    public String getCredentials() {
        return ticket;
    }

    public static UserAuthentication from(User user) {
        if ("OK".equals(user.getError())) {
            return new UserAuthentication(user.getUid().getValue(), user.getLogin(), user.getUserTicket());
        }
        LOG.warn("Unable to user authentication {}", user.getError());
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserAuthentication that = (UserAuthentication) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(login, that.login) &&
                Objects.equals(ticket, that.ticket);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), uid, login, ticket);
    }
}
